define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'tt_distribution/index' + location.search,
                    add_url: 'tt_distribution/add',
                    edit_url: 'tt_distribution/edit',
                    del_url: 'tt_distribution/del',
                    multi_url: 'tt_distribution/multi',
                    import_url: 'tt_distribution/import',
                    table: 'tt_distribution',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'id',
                sortName: 'id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title: __('Id')},
                        {field: 'primary_distribution', title: __('Primary_distribution')},
                        {field: 'secondary_distribution', title: __('Secondary_distribution')},
                        {field: 'third_distribution', title: __('Third_distribution')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});