define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'operators/index' + location.search,
                    add_url: 'operators/add',
                    // del_url: 'operators/del',
                    edit_url: 'operators/edit',
                    update_url: 'operators/edit',
                    table: 'operators',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'id',
                sortName: 'id',
                // 搜索按钮框展开
                searchFormVisible: true,
                //隐藏搜索框
                search:false,
                //隐藏切换按钮
                showToggle: false,
                //隐藏列按钮
                showColumns: false,
                //隐藏导出按钮
                showExport: false,
                columns: [
                    [
                        // {checkbox: false},
                        // {field: 'id', title: __('Id')},
                        {field: 'salt', title:"运营商推广码"},
                        {field: 'name', title:"运营商联系人", operate: 'LIKE'},
                        {field: 'mobile', title:"运营商联系电话", operate: 'LIKE'},
                        {field: 'role.id', title:"推广页数量", operate: false},
                        {field: 'role.id', title:"站长数量", operate: false},
                        {field: 'role.id', title:"拉新奖励", operate: false},
                        {field: 'role.id', title:"订单补贴", operate: false},
                        {field: 'role.id', title:"业绩奖金", operate: false},
                        {field: 'role.id', title:"运营补贴", operate: false},
                        {field: 'operate', title: __('Operate'),table:table,events: Table.api.events.operate, formatter: Table.api.formatter.operate },

                    ]
                ],
                // showColumns: false,
                // showToggle: false,
                // showExport: false,
                // commonSearch: false,
                // operate: false,
                // search:false
            });


            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };

    function  addFunctionAlty (value,row,index){
        return [
            '<button id="del" type="button" class="btn btn-default"> 删除</button>',
            '<button id="s" type="button" class="btn btn-default"> 查看收益</button>',
            '<button id="user" type="button" class="btn btn-default"> 查看站长</button>',
            '<button id="operators" type="button" class="btn btn-default"> 查看推广页</button>',
            '<button id="profit" type="button" class="btn btn-default"> 设置收益</button>',
        ].join("");
    }
    /*table: table,events:{
        "click #profit":function (e,value,row,index){
            var id = row.id;
            $.ajax({url:"Operators/profit?id="+id,success:function(result){
                    window.location.href = "Operators/profit?id="+id;
                }});
        },
        "click #del":function (e,value,row,index){

        },
        "click #s":function (e,value,row,index){

        },
        "click #user":function (e,value,row,index){

        },
        "click #operators":function (e,value,row,index){

        }
    },formatter:addFunctionAlty*/
    return Controller;
});