<?php

namespace app\index\controller;

use app\common\controller\Frontend;
use app\common\model\User;
use app\common\model\Ex;
use app\common\model\Material;
//include ROOT_PATH."extend/phpqrcode/qrlib.php";
//use QRcode;
class Index extends Frontend
{

    protected $noNeedLogin = '*';
    protected $noNeedRight = '*';
    protected $layout = '';
    private $watermark_on = '1';
    public function index()
    {


        if (!$this->auth->id) {
            $this->success(__('您未登录请登录'),  url('user/login'));
        }
        $this->success(__('订单'),  url('index/order'));
//        $this->order();
//        return $this->view->fetch();
    }

    public function order()
    {
        $info = User::get($this->auth->id);
        $data = Ex::Orders($info->popularize_id);
//        print_r($data);exit;
        $data['popularize_id'] = $info["popularize_id"];
        $this->view->assign('data', $data);
        $this->view->assign('username', $info->nickname);
        return $this->view->fetch();

    }
    public function materialList()
    {
        $info = User::get($this->auth->id);
        $data = Material::material($info->popularize_id,$info->nickname);
        $this->view->assign('data', $data);
        return $this->view->fetch();
    }
    public function imageExid (){
        $info = User::get($this->auth->id);
        $url = $_GET["url"];
        $id = $_GET["id"];
        $info = User::get($this->auth->id);
        $echo_png = "./uploads/material/".$info->popularize_id."_".$id."_".$info->id.".png";

        $image = $this->imageAddText($url,1,"来自".$info->nickname."站长的分享",$echo_png);
        $png = $this->imageEdit($image,"http://".$_SERVER["HTTP_HOST"]."/uploads/qrcode/".$info->popularize_id.".png", $echo_png);
        return "http://".$_SERVER["HTTP_HOST"].$echo_png;
    }
    /**添加图片ss**/
    public function imageEdit($url,$qrcode, $echo_png ){
        $dst_path = $url;
        $src_path = $qrcode ;
        //创建图片的实例
        $dst = imagecreatefromstring(file_get_contents($dst_path));
        $src = imagecreatefromstring(file_get_contents($src_path));
        //获取水印图片的宽高
        list($src_w, $src_h) = getimagesize($src_path);
        //将水印图片复制到目标图片上，最后个参数50是设置透明度，这里实现半透明效果
        imagecopymerge($dst, $src, 480, 970, 0, 0, $src_w, $src_h, 100);
//        $st = imagecopymerge($dst, $src, 0, 0, 0, 0, $src_w, $src_h, 50);
        //如果水印图片本身带透明色，则使用imagecopy方法
        //imagecopy($dst, $src, 10, 10, 0, 0, $src_w, $src_h);
        //输出图片

        $dst_type = 3;
        list($dst_w, $dst_h, $dst_type) = getimagesize($dst_path);
        switch ($dst_type) {
            case 1://GIF
                header('Content-Type: image/png');
                imagepng($dst,$echo_png);
//                imagegif($dst);
                break;
            case 2://JPG
                header('Content-Type: image/png');
                imagepng($dst,$echo_png);
//                imagejpeg($dst);
                break;
            case 3://PNG
                header('Content-Type: image/png');
                imagepng($dst,$echo_png);
                break;
            default:
                break;
        }
        imagedestroy($dst);
        imagedestroy($src);

    }
    /**
     * 给图片加文字
     * $bg_path    背景图地址
     * $text			要添加的文字
     * $x           文字在背景图片上位置的左边距,单位：px （例：436）
     * $y           文字在背景图片上位置的上边距,单位：px （例：1009）
     * $font_size	字体大小,单位：px （例：20）
     * $echo_path   生成的新图片存放路径
     **/
    public function imageAddText( $img,$pos=1,$text,$echo_png )
    {
        header("Content-type: image/png");
        $src = $img;
        $srcImageInfo=getimagesize($src);
        $srcImageWidth=$srcImageInfo[0];
        $srcImageHeight=$srcImageInfo[1];
        $srcImage=imagecreatefrompng($src);
        $img=imagecreatetruecolor($srcImageWidth,$srcImageHeight);
        $red=imagecolorallocate($img,255,255,255);//红色
        $waterText = $text;
        $font = './uploads/fonts.ttf';
        imagecopy($img,$srcImage,0, 0, 0, 0, $srcImageWidth, $srcImageHeight);
        imagettftext($img, 22, 0, 220, 160, $red, $font, $waterText);
        imagepng($img,$echo_png);//,'tt.png'
        return $echo_png;
    }
}


