<?php

namespace app\api\controller;

use app\common\controller\Api;
use think\Db;
include ROOT_PATH."extend/phpqrcode/qrlib.php";
use QRcode;
/**
 * 首页接口
 */
class Material extends Api
{
    protected $noNeedLogin = ['*'];
    protected $noNeedRight = ['*'];

    /**
     * 首页

     *
     *
     *
     */
    public function index()
    {
        $list = Db::table("fa_ex_fb")->where("id","between",[14501,15005])->select();
        foreach($list as $k=>$v){
                $png = $this->qcode($v["name5"],$v["name3"]);
        }
//        $png = $this->imageEdit("http://taote.com/uploads/20210713/f46f8fb6a5a46f119fa00c4ffd9c89a1.jpg","http://taote.com/uploads/qrcode/106324.png");
//        $image = $this->imageAddText("./uploads/material.png","来自某某某站长的分享",50,100,14,"./uploads/material.png");
    }
    /**生成二维码*/
    public function qcode($popularize_url,$popularize_id){
        QRcode::png($popularize_url,"./uploads/qrcode/".$popularize_id.".png");
    }





    /**添加图片**/
    public function imageEdit($url,$qrcode){
        $dst_path = $url;
        $src_path = $qrcode ;
        //创建图片的实例
        $dst = imagecreatefromstring(file_get_contents($dst_path));
        $src = imagecreatefromstring(file_get_contents($src_path));
        //获取水印图片的宽高
        list($src_w, $src_h) = getimagesize($src_path);
        //将水印图片复制到目标图片上，最后个参数50是设置透明度，这里实现半透明效果
        imagecopymerge($dst, $src, 460, 940, 0, 0, 200, 200, 100);

//        $font = './uploads/fonts.ttf';//字体
//        $black = imagecolorallocate($dst, 0, 0, 0);//字体颜色
//        imagefttext($dst, 13, 0, 20, 20, $black, $font, '快乐编程');

        //如果水印图片本身带透明色，则使用imagecopy方法
        //imagecopy($dst, $src, 10, 10, 0, 0, $src_w, $src_h);
        //输出图片
        $dst_type = 3;
        list($dst_w, $dst_h, $dst_type) = getimagesize($dst_path);
        switch ($dst_type) {
            case 1://GIF
                header('Content-Type: image/gif');
                imagegif($dst);
                break;
            case 2://JPG
                header('Content-Type: image/jpeg');
                imagejpeg($dst);
                break;
            case 3://PNG
                header('Content-Type: image/png');
                imagepng($dst,"./uploads/material.png");
                break;
            default:
                break;
        }
        imagedestroy($dst);
        imagedestroy($src);
    }
    /**
     * 给图片加文字
     * $bg_path    背景图地址
     * $text			要添加的文字
     * $x           文字在背景图片上位置的左边距,单位：px （例：436）
     * $y           文字在背景图片上位置的上边距,单位：px （例：1009）
     * $font_size	字体大小,单位：px （例：20）
     * $echo_path   生成的新图片存放路径
     **/
    public function imageAddText($bg_path, $text, $x, $y, $font_size, $echo_path){
        $dst_path = $bg_path;
        $dst = imagecreatefromstring(file_get_contents($dst_path));
        /*imagecreatefromstring()--从字符串中的图像流新建一个图像，返回一个图像标示符，其表达了从给定字符串得来的图像
        图像格式将自动监测，只要php支持jpeg,png,gif,wbmp,gd2.*/

        $font = __METHOD__.'./uploads/fonts.ttf';
        $black = imagecolorallocate($dst, 255,255,0);
        imagefttext($dst, 20, 0, 150, 120, $black, $font, $text);
        /*imagefttext($img,$size,$angle,$x,$y,$color,$fontfile,$text)
        $img由图像创建函数返回的图像资源
        size要使用的水印的字体大小
        angle（角度）文字的倾斜角度，如果是0度代表文字从左往右，如果是90度代表从上往下
        x,y水印文字的第一个文字的起始位置
        color是水印文字的颜色
        fontfile，你希望使用truetype字体的路径*/
        list($dst_w,$dst_h,$dst_type) = getimagesize($dst_path);
        /*list(mixed $varname[,mixed $......])--把数组中的值赋给一些变量
        像array()一样，这不是真正的函数，而是语言结构，List()用一步操作给一组变量进行赋值*/
        /*getimagesize()能获取到什么信息？
        getimagesize函数会返回图像的所有信息，包括大小，类型等等*/
        switch($dst_type){
            case 1://GIF
                header("content-type:image/gif");
                imagegif($dst);
                break;
            case 2://JPG
                header("content-type:image/jpeg");
                imagejpeg($dst);
                break;
            case 3://PNG
                header("content-type:image/png");
                imagepng($dst,$echo_path);
                break;
            default:
                break;
            /*imagepng--以PNG格式将图像输出到浏览器或文件
            imagepng()将GD图像流(image)以png格式输出到标注输出（通常为浏览器），或者如果用filename给出了文件名则将其输出到文件*/
        }
        imagedestroy($dst);
    }
}
