<?php

namespace app\index\controller;

use app\common\controller\Frontend;
use app\common\model\User;
use app\common\model\Ex;
use app\common\model\Material;

class Index extends Frontend
{

    protected $noNeedLogin = '*';
    protected $noNeedRight = '*';
    protected $layout = '';

    public function index()
    {


        if (!$this->auth->id) {
            $this->success(__('您未登录请登录'),  url('user/login'));
        }
        $this->success(__('订单'),  url('index/order'));
//        $this->order();
//        return $this->view->fetch();
    }

    public function order()
    {
        $info = User::get($this->auth->id);
        $data = Ex::Orders($info->popularize_id);
//        print_r($data);exit;
        $data['popularize_id'] = $info["popularize_id"];
        $this->view->assign('data', $data);
        return $this->view->fetch();

    }
    public function materialList()
    {
        $info = User::get($this->auth->id);
        $data = Material::material($info->popularize_id,$info->nickname);
        $this->view->assign('data', $data);
        return $this->view->fetch();
    }
}
